# 🚀 cPanel Deployment Guide for Instagram Downloader Backend

## ✅ Node.js Version Compatibility
- **Your cPanel supports:** Node.js 20.19.3
- **Project compatible:** ✅ Yes (requires >=16.0.0 <=20.19.3)

## 📁 Files to Upload to cPanel

Upload the **entire `backend` folder** containing:
```
backend/
├── server.js              ← Main server file
├── package.json           ← Dependencies & scripts
├── package-lock.json      ← Dependency lock file
├── node_modules/          ← All installed packages
├── public/                ← Static files
│   └── index.html        ← Instagram downloader page
├── DEPLOYMENT.md          ← This file
└── README.md              ← Project documentation
```

## 🔧 cPanel Setup Steps

### 1. Access cPanel
- Login to your cPanel account
- Navigate to **"File Manager"**

### 2. Create Directory
- Go to `public_html/` (or your domain root)
- Create a new folder called `backend` or `api`

### 3. Upload Files
- Upload all files from your local `backend/` folder
- Make sure to include the `node_modules/` folder

### 4. Configure Node.js
- In cPanel, find **"Node.js"** or **"Node.js Selector"**
- Select **Node.js version 20.19.3**
- Set **Node.js app root** to your `backend` folder
- Set **Application URL** to your domain (e.g., `yourdomain.com/backend`)

### 5. Set Environment Variables
- **NODE_ENV:** `production`
- **PORT:** `3000` (or whatever port cPanel assigns)

## 🌐 Update Your Flutter App

After deployment, update your `igmobile/lib/config.dart`:

```dart
// Change from local IP to your domain
static const String androidDevUrl = 'https://yourdomain.com/backend/';
static const String iosDevUrl = 'https://yourdomain.com/backend/';
static const String devUrl = 'https://yourdomain.com/backend/';
```

## 🧪 Test Your Deployment

1. **Test the page:** `https://yourdomain.com/backend/`
2. **Test the API:** `https://yourdomain.com/backend/api/health`
3. **Test download:** Use the Instagram downloader interface

## ⚠️ Important Notes

- **Puppeteer:** May not work on shared hosting (requires system dependencies)
- **Port:** cPanel usually assigns a random port, not 5000
- **HTTPS:** Make sure your domain has SSL certificate
- **CORS:** The server is configured to allow all origins for development

## 🔍 Troubleshooting

### If you get "Module not found" errors:
- Make sure `node_modules/` folder was uploaded
- Check that `package.json` is in the correct location

### If the server won't start:
- Check cPanel error logs
- Verify Node.js version is set to 20.19.3
- Make sure the app root path is correct

### If you get CORS errors:
- The server is configured to allow all origins
- Check that your domain is in the CORS allowed origins list

## 📞 Support

If you encounter issues:
1. Check cPanel error logs
2. Verify all files were uploaded correctly
3. Ensure Node.js version is set to 20.19.3
4. Check that the app root path matches your folder structure
